<?php
	/*
	* ContactMap Component Google Map for Joomla! 3.x
	* Version J3.0
	* Creation date: Août 2014
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: webmaster@gmapfp.org
	* License GNU/GPL
	*/

defined('_JEXEC') or die;

JLoader::register('ContactMapHelper', JPATH_COMPONENT . '/helpers/contactmap.php');

class ContactMapViewMarqueur extends JViewLegacy
{
	protected $form;
	protected $item;
	protected $state;
	protected $canDo;

	public function display($tpl = null)
	{
		$this->form		= $this->get('Form');
		$this->item		= $this->get('Item');
		$this->state	= $this->get('State');
		$this->canDo	= JHelperContent::getActions('com_contactmap');

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));

			return false;
		}

		$this->addToolbar();
		parent::display($tpl);
	}

	protected function addToolbar()
	{
		JFactory::getApplication()->input->set('hidemainmenu', true);

		$user		= JFactory::getUser();
		$isNew		= ($this->item->id == 0);
		$canDo		= $this->canDo;

		JToolbarHelper::title($isNew ? JText::_('COM_CONTACTMAP_MANAGER_MARQUEUR_NEW') : JText::_('COM_CONTACTMAP_MANAGER_MARQUEUR_EDIT'), 'bookmark banners-clients');

		// If not checked out, can save the item.
		if ($canDo->get('core.edit') || $canDo->get('core.create'))
		{
			JToolbarHelper::apply('marqueur.apply');
			JToolbarHelper::save('marqueur.save');
		}

		if ($canDo->get('core.create'))
		{
			JToolbarHelper::save2new('marqueur.save2new');
		}
		// If an existing item, can save to a copy.
		if (!$isNew && $canDo->get('core.create'))
		{
			JToolbarHelper::save2copy('marqueur.save2copy');
		}

		if (empty($this->item->id))
		{
			JToolbarHelper::cancel('marqueur.cancel');
		}
		else
		{
			if ($this->state->params->get('save_history', 0) && $user->authorise('core.edit'))
			{
				JToolbarHelper::versions('com_contactmap.marqueur', $this->item->id);
			}

			JToolbarHelper::cancel('marqueur.cancel', 'JTOOLBAR_CLOSE');
		}
	}
}
